unit FormOsoba;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, DB,
  Dialogs, ComCtrls, StdCtrls, Mask, Buttons;

type
  TFOsoba = class(TForm)
    btnAnuluj: TBitBtn;
    btnOK: TBitBtn;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicaINr: TMaskEdit;
    meKodp: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    procedure btnOKClick(Sender: TObject);

  private
	 bTryb_edycji : Boolean;
	 idosoby      : Integer;

	// ustawiam kontrolki ekranowe
	procedure   Set_idosoby(const Value : Integer);

	procedure   Set_nazwisko(const Value : String);
	procedure   Set_imie(const Value : String);
	procedure   Set_dataur(const Value : TDate);
	procedure   Set_mcowosc(const Value : String);
	procedure   Set_ulicainr(const Value : String);
	procedure   Set_kodp(const Value : String);
	procedure   Set_miasto(const Value : String);
	procedure   Set_pesel(const Value : String);

	// pobieram wartoci z kontrolki ekranowe

	function   Get_idosoby() : Integer;
	function   Get_nazwisko() : String;
	function   Get_imie() : String;
	function   Get_dataur() : TDate;
	function   Get_mcowosc() : String;
	function   Get_ulicainr() : String;
	function   Get_kodp() : String;
	function   Get_miasto() : String;
	function   Get_pesel() : String;

	procedure  My_edit();
	procedure  My_insert();




  public
	 constructor Create(AOwner : TComponent; tryb : Boolean);
  end;

var
  FOsoba: TFOsoba;

implementation

uses DataModule;
{$R *.dfm}
{------------------------------------------------------------------------------}
constructor TFOsoba.Create(AOwner : TComponent; tryb : Boolean);
begin
   inherited Create(AOwner);

	bTryb_edycji := tryb;


   if bTryb_edycji then
	begin
      Set_idosoby(DM.ADODataSetBrowse.FieldByName('IDOSOBY').AsInteger);
      Set_nazwisko(DM.ADODataSetBrowse.FieldByName('NAZWISKO').AsString);
      Set_imie(DM.ADODataSetBrowse.FieldByName('IMIE').AsString);
      Set_dataur(DM.ADODataSetBrowse.FieldByName('DATAUR').AsDateTime);
      Set_mcowosc(DM.ADODataSetBrowse.FieldByName('MCOWOSC').AsString);
      Set_ulicainr(DM.ADODataSetBrowse.FieldByName('ULICAINR').AsString);
      Set_kodp(DM.ADODataSetBrowse.FieldByName('KODP').AsString);
      Set_miasto(DM.ADODataSetBrowse.FieldByName('MIASTO').AsString);
      Set_pesel(DM.ADODataSetBrowse.FieldByName('PESEL').AsString);
   end
   else begin
      Set_nazwisko('');
      Set_imie('');
      Set_dataur(Now());
      Set_mcowosc('');
      Set_ulicainr('');
      Set_kodp('');
      Set_miasto('');
      Set_pesel('');
   end;
end;

procedure TFOsoba.Set_idosoby(const Value : Integer);
begin
	idosoby := Value;
end;

procedure TFOsoba.Set_nazwisko(const Value : String);
begin
	meNazwisko.Text := Value;
end;

procedure TFOsoba.Set_imie(const Value : String);
begin
   meImie.Text := Value;
end;

procedure TFOsoba.Set_dataur(const Value : TDate);
begin
   dtpDataUr.Date := Date();
end;

procedure TFOsoba.Set_mcowosc(const Value : String);
begin
   meMcowosc.Text := Value;
end;

procedure TFOsoba.Set_ulicainr(const Value : String);
begin
   meUlicaINr.Text := Value;
end;

procedure TFOsoba.Set_kodp(const Value : String);
begin
   meKodp.Text := Value;
end;

procedure TFOsoba.Set_miasto(const Value : String);
begin
   meMiasto.Text := Value;
end;

procedure TFOsoba.Set_pesel(const Value : String);
begin
   mePesel.Text := Value;
end;

function TFOsoba.Get_idosoby() : Integer;
begin
   Result := idosoby;
end;

function TFOsoba.Get_nazwisko() : String;
begin
   Result := meNazwisko.Text;
end;

function TFOsoba.Get_imie() : String;
begin
   Result := meImie.Text;
end;

function TFOsoba.Get_dataur() : TDate;
begin
   Result := dtpDataUr.Date;
end;

function TFOsoba.Get_mcowosc() : String;
begin
   Result := meMcowosc.Text;
end;

function TFOsoba.Get_ulicainr() : String;
begin
   Result := meUlicaINr.Text;
end;

function TFOsoba.Get_kodp() : String;
begin
   Result := meKodp.Text;
end;

function TFOsoba.Get_miasto() : String;
begin
   Result := meMiasto.Text;
end;

function TFOsoba.Get_pesel() : String;
begin
   Result := mePesel.Text;
end;

procedure TFOsoba.My_edit();
var
	zakladka : TBookmark;

begin
   zakladka := DM.ADODataSetBrowse.GetBookmark();

   DM.adocEDIT.Parameters.ParamByName('IDOSOBY').Value  := Get_idosoby();
   DM.adocEDIT.Parameters.ParamByName('NAZWISKO').Value := Get_nazwisko();
   DM.adocEDIT.Parameters.ParamByName('IMIE').Value     := Get_imie();
   DM.adocEDIT.Parameters.ParamByName('DATAUR').Value   := Get_dataur();
   DM.adocEDIT.Parameters.ParamByName('MCOWOSC').Value  := Get_mcowosc();
   DM.adocEDIT.Parameters.ParamByName('ULICAINR').Value := Get_ulicainr();
   DM.adocEDIT.Parameters.ParamByName('KODP').Value     := Get_kodp();
   DM.adocEDIT.Parameters.ParamByName('MIASTO').Value   := Get_miasto();
   DM.adocEDIT.Parameters.ParamByName('PESEL').Value    := Get_pesel();

   try
      DM.adocEDIT.Execute();
   finally
      // odswie ekran
      DM.ADODataSetBrowse.Close();
      DM.ADODataSetBrowse.Open();

      DM.ADODataSetBrowse.GotoBookmark(zakladka);
      DM.ADODataSetBrowse.FreeBookmark(zakladka);
   end;
end;

procedure TFOsoba.My_insert();
begin
   DM.adocINSERT.Parameters.ParamByName('NAZWISKO').Value := Get_nazwisko();
   DM.adocINSERT.Parameters.ParamByName('IMIE').Value     := Get_imie();
   DM.adocINSERT.Parameters.ParamByName('DATAUR').Value   := Get_dataur();
   DM.adocINSERT.Parameters.ParamByName('MCOWOSC').Value  := Get_mcowosc();
   DM.adocINSERT.Parameters.ParamByName('ULICAINR').Value := Get_ulicainr();
   DM.adocINSERT.Parameters.ParamByName('KODP').Value     := Get_kodp();
   DM.adocINSERT.Parameters.ParamByName('MIASTO').Value   := Get_miasto();
   DM.adocINSERT.Parameters.ParamByName('PESEL').Value    := Get_pesel();

   try
      DM.adocINSERT.Execute();
   finally
      // odswie ekran
      DM.ADODataSetBrowse.Close();
      DM.ADODataSetBrowse.Open();
   end;
end;

procedure TFOsoba.btnOKClick(Sender: TObject);
begin
   dtpDataUr.Time := 0;

   if meNazwisko.Text = '' then
   begin
      meNazwisko.Color  := clRed;
      ModalResult        := mrNone;
   end
   else begin
	   if bTryb_edycji then
      begin
         My_edit();
      end
      else begin
         My_insert();
      end;
   end;
end;

end.

